IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[P_PDV_VD_IT_COMIS_RECALC_QTDE_HISTORICO]')
          AND type IN(N'P', N'PC')
)
    BEGIN
        DROP PROCEDURE [P_PDV_VD_IT_COMIS_RECALC_QTDE_HISTORICO]
    END;
GO

--EXEC P_PDV_VD_IT_COMIS_RECALC_QTDE 1,'2','','2016-10-25','2016-10-25',0
CREATE PROCEDURE [P_PDV_VD_IT_COMIS_RECALC_QTDE_HISTORICO] (   @CD_EMP      INT = 1,
										   @CD_FILIAL   VARCHAR(MAX), 
										   @CD_FUN      VARCHAR(MAX)='',                           
										   @DT_INI      DATETIME = NULL,
										   @DT_FIM      DATETIME = NULL,
										   @CD_PROD     INT=0) 
AS
SET NOCOUNT ON  
--BEGIN TRY
BEGIN

DECLARE @CD_EMP_RS		INT
DECLARE @CD_FILIAL_RS	INT
DECLARE @CD_VD_RS		INT
DECLARE @CD_PROD_RS		INT
DECLARE @CD_VEND		INT
DECLARE @CD_VEND_RS		INT
DECLARE @DS_PROD        VARCHAR(200)

DECLARE @PERC_COMIS MONEY
DECLARE @DS_PERC_COMIS VARCHAR(100)
DECLARE @VLR_COMISSAO_FABRIC MONEY
DECLARE @DS_VLR_COMIS VARCHAR(100)

create table #tmp_filial(cd_emp int, cd_filial int)
create table #tmp_vend(cd_fun int)

	insert into #tmp_filial
	SELECT @CD_EMP, ID FROM UFD_PRM_IN_STRING(@CD_FILIAL)

	insert into #tmp_vend
	 SELECT ID FROM UFD_PRM_IN_STRING(@CD_FUN) 



SELECT *
INTO #V_EST_PROD_TBL_COMIS_POSSUI
FROM V_EST_PROD_TBL_COMIS_POSSUI_HISTORICO

CREATE TABLE #VendaComissao (CD_EMP INT,
							 CD_FILIAL INT,
							 CD_VD INT,
							 CD_PROD INT,
							 CD_VEND INT,
							 QT_IT MONEY,
							 DT_VD DATETIME)

 IF LTRIM(RTRIM(@CD_FUN))<>''
 begin
 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
       a.CD_PROD,
       a.CD_VEND,
	   SUM(A.QT_IT),
	   A.DT_VD
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_vend v on
	  v.cd_fun= a.CD_VEND  
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP   
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
	  INNER JOIN #V_EST_PROD_TBL_COMIS_POSSUI pc ON
	  A.CD_EMP = pc.CD_EMP AND 
	  A.CD_FILIAL = pc.CD_FILIAL AND
	  A.CD_PROD = pc.CD_PROD AND
	  pc.TIPO_COMISSAO=1
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
	GROUP BY
	   a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
       a.CD_PROD,
       a.CD_VEND
end

IF LTRIM(RTRIM(@CD_FUN))=''
  begin
 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
       a.CD_PROD,
       a.CD_VEND,
	   SUM(A.QT_IT),
	   A.DT_VD
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP  
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
	  INNER JOIN #V_EST_PROD_TBL_COMIS_POSSUI pc ON
	  A.CD_EMP = pc.CD_EMP AND 
	  A.CD_FILIAL = pc.CD_FILIAL AND
	  A.CD_PROD = pc.CD_PROD AND
	  pc.TIPO_COMISSAO=1	   
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
	GROUP BY
	   a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
       a.CD_PROD,
       a.CD_VEND
end
------------------------------------------------------------------------------------------------------------------------
-- Gravando a pontuação de vendas
------------------------------------------------------------------------------------------------------------------------
--Nome do cursor
DECLARE ComissaoItensQtde CURSOR FAST_FORWARD FOR
-- Select utilizado para o cursor
SELECT  DISTINCT a.CD_EMP,
    a.CD_FILIAL,
    a.CD_VD,
    a.CD_PROD,
    a.CD_VEND,
	ISNULL(F.PERC_COMIS,0),
	ISNULL(F.DS_COMIS_PERC,'NAO DEFINIDO'),
	ISNULL(F.VLR_COMIS,0),
	ISNULL(F.DS_COMIS_VLR,'NAO DEFINIDO'),
	EST_PROD.DS_PROD
FROM 
	#VendaComissao a INNER JOIN EST_PROD ON
	a.CD_EMP = EST_PROD.CD_EMP AND
	a.CD_PROD = EST_PROD.CD_PROD 
	OUTER APPLY UFD_EST_PROD_COMIS_QTDE_HISTORICO(A.CD_EMP, a.CD_FILIAL, a.CD_PROD, a.CD_VEND,A.QT_IT, A.DT_VD) F 

  --Abrindo cursor
  OPEN ComissaoItensQtde

  --Atribuindo valores do select nas variáveis
  FETCH NEXT FROM ComissaoItensQtde INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD


  --Iniciando laço
  WHILE @@FETCH_STATUS = 0
   BEGIN   
		print 'Vendedor.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD + ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.:  ' + @DS_VLR_COMIS
	    IF @PERC_COMIS > 0
		begin
			UPDATE I
				SET 
					I.PERC_COMIS = CASE WHEN @PERC_COMIS=0 THEN PERC_COMIS ELSE @PERC_COMIS END,
					I.PERC_COMI = CASE WHEN @PERC_COMIS=0 THEN PERC_COMIS ELSE @PERC_COMIS END,
					I.DS_PERC_COMIS = CASE WHEN @PERC_COMIS=0 THEN DS_PERC_COMIS ELSE @DS_PERC_COMIS END,
					I.VLR_COMISSAO_FABRIC =CASE WHEN @PERC_COMIS=0 THEN VLR_COMISSAO_FABRIC ELSE @VLR_COMISSAO_FABRIC END,
					I.DS_VLR_COMIS = CASE WHEN @PERC_COMIS=0 THEN DS_VLR_COMIS ELSE @DS_VLR_COMIS END
				FROM  PDV_VD_IT I
				WHERE I.CD_EMP = @CD_EMP_RS
					 AND I.CD_FILIAL = @CD_FILIAL_RS        
					 AND I.CD_VD = @CD_VD_RS
					 AND I.CD_VEND = @CD_VEND_RS
					 AND I.CD_PROD = @CD_PROD_RS
		end
      --Próxima linha do cursor
	FETCH NEXT FROM ComissaoItensQtde INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD
  
   END

	CLOSE ComissaoItensQtde
	DEALLOCATE ComissaoItensQtde 
  


----Nome do cursor para devolução
--DECLARE ComissaoItensQtdeDev CURSOR FOR
--  -- Select utilizado para o cursor
--  SELECT  DISTINCT a.CD_EMP,
--       a.CD_FILIAL,
--       a.CD_VD,
--       a.CD_IT,
--       a.CD_PROD,
--       a.CD_VEND,
--	   ISNULL(F.PERC_COMIS,0),
--	   ISNULL(F.DS_COMIS_PERC,'NAO DEFINIDO'),
--	   ISNULL(F.VLR_COMIS,0),
--	   ISNULL(F.DS_COMIS_VLR,'NAO DEFINIDO')
--  FROM PDV_VD_DEV_EST_PROD_IMP A 
--		INNER JOIN PDV_VD b on
--	    a.CD_EMP        = b.CD_EMP
--	    and a.CD_FILIAL = b.CD_FILIAL
--	    and a.CD_VD     = b.CD_VD

--		inner join #tmp_vend v on
--		a.cd_vend = v.cd_fun  

--		inner join #tmp_filial L on
--		A.CD_FILIAL= L.CD_FILIAL AND
--		A.CD_EMP	 = L.CD_EMP  

--		OUTER APPLY UFD_EST_PROD_COMIS_QTDE(a.CD_EMP, a.CD_FILIAL, a.CD_PROD, a.CD_VEND) F 
--  WHERE
--       a.CD_EMP = @CD_EMP 
--       AND A.DT_DEVO between @DT_INI AND @DT_FIM
--	   AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
--  --Abrindo cursor
--  OPEN ComissaoItensQtdeDev
  
--  --Atribuindo valores do select nas variáveis
--	FETCH NEXT FROM ComissaoItensQtdeDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
--													@CD_PROD_RS, @CD_VEND_RS,
--													@PERC_COMIS,@DS_PERC_COMIS,
--													@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS

--  --Iniciando laço
--  WHILE @@FETCH_STATUS = 0
--   BEGIN   
--		Print 'Devolucao ' + convert(varchar, @CD_EMP_RS) + ' Filial ' + convert(varchar, @CD_FILIAL_RS)
--		Print @CD_VD_RS
--		Print @CD_VEND_RS
--		Print @CD_IT_RS  
--		Print @PERC_COMIS
--		Print @VLR_COMISSAO_FABRIC

--	    UPDATE I
--		    SET 
--				I.PERC_COMIS = @PERC_COMIS,
--				I.DS_PERC_COMIS = @DS_PERC_COMIS,
--				I.VLR_COMISSAO_FABRIC = @VLR_COMISSAO_FABRIC,
--				I.DS_VLR_COMIS = @DS_VLR_COMIS	
--		    FROM PDV_VD_DEV_EST_PROD_IMP i			
--		    WHERE I.CD_EMP = @CD_EMP_RS
--				 AND I.CD_FILIAL = @CD_FILIAL_RS        
--				 AND I.CD_VD = @CD_VD_RS
--				 AND I.CD_VEND = @CD_VEND_RS
--				 AND I.CD_IT = @CD_IT_RS				
--				 AND (isnull(I.PERC_COMIS,0) <> @PERC_COMIS OR
--					  isnull(I.VLR_COMISSAO_FABRIC,0) <> @VLR_COMISSAO_FABRIC)
--	print @@rowcount
--      --Próxima linha do cursor
--	FETCH NEXT FROM ComissaoItensQtdeDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
--								@CD_PROD_RS, @CD_VEND_RS,
--								@PERC_COMIS,@DS_PERC_COMIS,
--								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS
    
--   END

	
  --DEALLOCATE ComissaoItensQtdeDev 
  --CLOSE ComissaoItensQtdeDev

   	
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_vend') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_vend
	END	
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_filial') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_filial
	END

	IF  OBJECT_ID('TEMPDB.DBO.#VendaComissao') IS NOT NULL
	BEGIN
			DROP TABLE #VendaComissao
	END
END
/*
END TRY
BEGIN CATCH
	print 'Erro '+ ERROR_MESSAGE()
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
		ERROR_NUMBER() AS numero,
		ERROR_SEVERITY() AS severidade,
		ERROR_STATE() AS estado,
		ERROR_PROCEDURE() AS rotina,
		ERROR_LINE() AS linha,
		ERROR_MESSAGE() AS mensagem,
		GETDATE() AS dtErro; 
END CATCH
*/
GO


